// =====================================
//  WndProc
// =====================================

#define STRICT
#include <windows.h>
#include <stdio.h>
#include <string.h>

void PrintMsg(HWND, WPARAM, LPARAM, char *);

static int cxChar, cyChar;
RECT rect;

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;              //   
  PAINTSTRUCT ps;       //   
  static TEXTMETRIC tm; //    
                        // 

  switch (msg)
  {
    case WM_CREATE:
    {
      //   ,
      //     
      hdc = GetDC(hwnd);

      //      
      SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

      //   
      //   ,  
      //  
      GetTextMetrics(hdc, &tm);

      //    
      //   
      cxChar = tm.tmMaxCharWidth;

      //     
      //   
      cyChar = tm.tmHeight + tm.tmExternalLeading;

      //  
      ReleaseDC(hwnd, hdc);

      //    
      //  .    
      //    
      rect.top = 3 * cyChar;

      return 0;
    }

    case WM_SIZE:
    {
      //    
      //  
      rect.right  = LOWORD(lParam);
      rect.bottom = HIWORD(lParam);

      //   
      InvalidateRect(hwnd, NULL, TRUE);
      UpdateWindow(hwnd);

      return 0;
    }

    case WM_PAINT:
    {
      //    
      char szHead1[] =
	"Message              Char  wParam lParam   KeyName";
      char szHead2[] =
	"-------              ----  ------ ------   -------";

      hdc = BeginPaint(hwnd, &ps);

      //      
      SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

      //   
      TextOut(hdc, cxChar, cyChar/2,
        szHead1, sizeof(szHead1) - 1);
      TextOut(hdc, cxChar, cyChar/2 + cyChar,
        szHead2, sizeof(szHead2) - 1);

      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_KEYDOWN:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_KEYDOWN");
      break;
    }

    case WM_KEYUP:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_KEYUP");
      break;
    }

    case WM_SYSKEYDOWN:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_SYSKEYDOWN");
      break;
    }

    case WM_SYSKEYUP:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_SYSKEYUP");
      break;
    }

    case WM_CHAR:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_CHAR");
      break;
    }

    case WM_SYSCHAR:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_SYSCHAR");
      break;
    }

    case WM_DEADCHAR:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_DEADCHAR");
      break;
    }

    case WM_SYSDEADCHAR:
    {
      PrintMsg(hwnd, wParam, lParam, "WM_SYSDEADCHAR");
      break;
    }

    case WM_DESTROY:
    {
      PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}

// ==========================================
//     
//    
// ==========================================

void PrintMsg(HWND hwnd, WPARAM wParam, LPARAM lParam,
	char *szMsg)
{
  HDC  hdc;
  char szBuf[256];
  char szKeyName[20];
  int  nBufSize;
  int  rc;

  //   ,   
  ScrollWindow(hwnd, 0, -cyChar, &rect, &rect);

  hdc = GetDC(hwnd);

  //      
  SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

  //   ,  
  //  
  rc = GetKeyNameText(lParam, szKeyName, 20);
  if(!rc) MessageBeep(0);

  //  ,  
  nBufSize = wsprintf(szBuf,
    "%-14s       %c     %02x     %08lX %-20s",
    (LPSTR)szMsg, (BYTE)wParam, (BYTE)wParam,
    lParam, (LPSTR)szKeyName);

  //      
  TextOut(hdc, cxChar, rect.bottom - cyChar, szBuf, nBufSize);

  ReleaseDC(hwnd, hdc);

  //      
  //  ,  
  ValidateRect(hwnd, NULL);
}
