// =====================================
//  WndProc
// =====================================

#define STRICT
#include <windows.h>

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC        hdc;
  WORD       xPosScr, yPosScr, nSizeScr;
  WORD       xPos, yPos, nSize;
  BYTE       szBuf[80];

  static TEXTMETRIC tm;
  static int cxChar, cyChar;

  switch (msg)
  {
	 case WM_CREATE:
    {
      //   ,
      //     
      hdc = GetDC(hwnd);

      //      
      SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

		//   
      //   ,  
      //  
      GetTextMetrics(hdc, &tm);

      //    
      //   
      cxChar = tm.tmMaxCharWidth;

      //     
      //   
      cyChar = tm.tmHeight + tm.tmExternalLeading;

      //  
      ReleaseDC(hwnd, hdc);

		return 0;
    }

	 case WM_NCHITTEST:
    {
		//       ,
		//      
		//    ,   
		//      
		// 

      //	return HTCAPTION;

		//    
		xPosScr  = LOWORD(lParam);
		yPosScr	= HIWORD(lParam);

      hdc = GetDC(hwnd);

      //   , 
      //   
		nSize = wsprintf(szBuf, "(%-3d, %-3d)",
		  xPosScr, yPosScr);

		//      
      SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

		//     
		TextOut(hdc, cxChar, 0, szBuf, nSize);

      ReleaseDC(hwnd, hdc);
		break;
	 }

	 case WM_MOUSEMOVE:
    {
		//    
      xPos   = LOWORD(lParam);
      yPos   = HIWORD(lParam);

      hdc = GetDC(hwnd);

      //   , 
      //   
      nSize = wsprintf(szBuf, "(%-3d, %-3d)", xPos, yPos);

		//      
      SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

		//     
		TextOut(hdc, cxChar, cyChar, szBuf, nSize);

      ReleaseDC(hwnd, hdc);
		break;
	 }

	 //     
    //   
    case WM_LBUTTONDBLCLK:
	 case WM_DESTROY:
	 {
		PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}

