// =====================================
//  WndProc
// =====================================

#define STRICT
#include <windows.h>

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;

  switch (msg)
  {
    //    
    case WM_LBUTTONDOWN:
    {
      WORD xPos, yPos, nSize;
      BYTE szBuf[80];

      //    
      xPos   = LOWORD(lParam);
      yPos   = HIWORD(lParam);

      hdc = GetDC(hwnd);

      //   , 
      //   
      nSize = wsprintf(szBuf, "(%d, %d)", xPos, yPos);

      //    
      //  ,  
      //   
      TextOut(hdc, xPos, yPos, szBuf, nSize);

      ReleaseDC(hwnd, hdc);
      return 0;
    }

    //    
    case WM_RBUTTONDOWN:
    {
      //   ,  
      InvalidateRect(hwnd, NULL, TRUE);
      UpdateWindow(hwnd);
      return 0;
    }

    //     
    case WM_LBUTTONDBLCLK:
    {
      //  
      MessageBox(hwnd, " !",
	"MouseXY", MB_OK | MB_ICONINFORMATION);
      return 0;
    }

    case WM_DESTROY:
    {
      PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}

