// ----------------------------------------
//    Windows
// ----------------------------------------

#define STRICT
#include <windows.h>
#include <stdio.h>

//    
//   Windows
static struct {
    int  Const;
    char String[40];
} SMTable[] = {

  { SM_CXBORDER,        "SM_CXBORDER"},
  { SM_CYBORDER,        "SM_CYBORDER"},
  { SM_CYCAPTION,       "SM_CYCAPTION"},
  { SM_CXCURSOR,        "SM_CXCURSOR"},
  { SM_CYCURSOR,        "SM_CYCURSOR"},
  { SM_CXDLGFRAME,      "SM_CXDLGFRAME"},
  { SM_CYDLGFRAME,      "SM_CYDLGFRAME"},
  { SM_CXDOUBLECLK,     "SM_CXDOUBLECLK"},      
  { SM_CYDOUBLECLK,     "SM_CYDOUBLECLK"},
  { SM_CXFRAME,         "SM_CXFRAME"},
  { SM_CYFRAME,         "SM_CYFRAME"},
  { SM_CXFULLSCREEN,    "SM_CXFULLSCREEN"},
  { SM_CYFULLSCREEN,    "SM_CYFULLSCREEN"},
  { SM_CXHSCROLL,       "SM_CXHSCROLL"},
  { SM_CYHSCROLL,       "SM_CYHSCROLL"},
  { SM_CXHTHUMB,        "SM_CXHTHUMB"},
  { SM_CXICON,          "SM_CXICON"},
  { SM_CYICON,          "SM_CYICON"},
  { SM_CXICONSPACING,   "SM_CXICONSPACING"},
  { SM_CYICONSPACING,   "SM_CYICONSPACING"}, 
  { SM_CYKANJIWINDOW,   "SM_CYKANJIWINDOW"},
  { SM_CYMENU,          "SM_CYMENU"},
  { SM_CXMIN,           "SM_CXMIN"},
  { SM_CYMIN,           "SM_CYMIN"},
  { SM_CXMINTRACK,      "SM_CXMINTRACK"},
  { SM_CYMINTRACK,      "SM_CYMINTRACK"},
  { SM_CXSCREEN,        "SM_CXSCREEN"},
  { SM_CYSCREEN,        "SM_CYSCREEN"},
  { SM_CXSIZE,          "SM_CXSIZE"},
  { SM_CYSIZE,          "SM_CYSIZE"},
  { SM_CXVSCROLL,       "SM_CXVSCROLL"},
  { SM_CYVSCROLL,       "SM_CYVSCROLL"},
  { SM_CYVTHUMB,        "SM_CYVTHUMB"},
  { SM_DBCSENABLED,     "SM_DBCSENABLED"},
  { SM_DEBUG,           "SM_DEBUG"},
  { SM_MENUDROPALIGNMENT, "SM_MENUDROPALIGNMENT"}, 
  { SM_MOUSEPRESENT,    "SM_MOUSEPRESENT"},
  { SM_PENWINDOWS,      "SM_PENWINDOWS"},       
  { SM_RESERVED1,       "SM_RESERVED1"},
  { SM_RESERVED2,       "SM_RESERVED2"},
  { SM_RESERVED3,       "SM_RESERVED3"},
  { SM_RESERVED4,       "SM_RESERVED4"},
  { SM_SWAPBUTTON,      "SM_SWAPBUTTON"}
};

// ===========================================
//  WinMain
// ===========================================

#pragma argsused

int PASCAL
WinMain(HINSTANCE hInstance,
		HINSTANCE hPrevInstance,
		LPSTR     lpszCmdLine,
		int       nCmdShow)
{
  FILE *out;     //   
  int i;         //  
  char buf[80];  //  

  //     
  //  
  //     , 
  //   
  if ((out = fopen("sysmet.txt", "wt")) == NULL)
  {
    MessageBox(NULL,
     "    sysmet.txt",
     "", MB_OK | MB_ICONSTOP);
    return 1;
  }

  //   
  fputs("* ================================= *\n", out);
  fputs("* SYSMETRICS, (C) Frolov A.V., 1994 *\n", out);
  fputs("* ================================= *\n\n", out);

  //      
  //     
  //      
  for(i=0; i < sizeof(SMTable)/sizeof(SMTable[0]); i++)
  {
    sprintf(buf, "%s\t = %d\n",
      SMTable[i].String,
      GetSystemMetrics(SMTable[i].Const));

    //    
    fputs(buf, out);
  }

  //  
  fclose(out);

  MessageBox(NULL,
    "C  Windows  "
    "  sysmet.txt", "SYSMETRIC", MB_OK);

  return 0;
}