// =====================================
//  WndProc
//     
//  
// =====================================

#define STRICT
#include <windows.h>

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;             //   
  PAINTSTRUCT ps;      //   

  switch (msg)
  {
    case WM_PAINT:
    {
      //    
      hdc = BeginPaint(hwnd, &ps);

      //   
      TextOut(hdc, 10, 20, " WM_PAINT", 18);

      //    
      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_LBUTTONDOWN:
    {
      //    
      hdc = GetDC(hwnd);

      //   
      TextOut(hdc, 10, 40, " WM_LBUTTONDOWN", 24);

      //    
      ReleaseDC(hwnd, hdc);
      return 0;
    }

    case WM_RBUTTONDOWN:
    {
      hdc = GetDC(hwnd);
      TextOut(hdc, 10, 60, " WM_RBUTTONDOWN", 24);
      ReleaseDC(hwnd, hdc);
      return 0;
    }

    case WM_DESTROY:
    {
      PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}
