// ----------------------------------------
//  
// ----------------------------------------

#define STRICT
#include <windows.h>
#include <mem.h>

BOOL InitApp(HINSTANCE);
LRESULT CALLBACK _export WndProc(HWND, UINT, WPARAM, LPARAM);

char const szClassName[]   = "TMCLOCKAppClass";
char const szWindowTitle[] = "TMCLOCK Application";

TEXTMETRIC tm;
int cxChar, cyChar;
RECT rc;

// =====================================
//  WinMain
// =====================================
#pragma argsused

int PASCAL
WinMain(HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR     lpszCmdLine,
	int       nCmdShow)
{
  MSG  msg;   //     
  HWND hwnd;  //    

  if(!InitApp(hInstance))
      return FALSE;

  //    Desktop.
  //      
  //       
  GetWindowRect(GetDesktopWindow(), &rc);

  //     
  //    ,  
  //    .
  //     
  //     
  hwnd = CreateWindow(
    szClassName, szWindowTitle, 
    WS_POPUPWINDOW | WS_THICKFRAME,
    100, 100,
    100, 100,
    0, 0, hInstance, NULL); 

  if(!hwnd)
    return FALSE;

  //     
  //  
  MoveWindow(hwnd,
    rc.right  - cxChar * 15,
    rc.bottom - cyChar * 3,
    cxChar * 10, cyChar * 2, TRUE);

  //     
  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  while(GetMessage(&msg, 0, 0, 0))
  {
    DispatchMessage(&msg);
  }
  return msg.wParam;
}

// =====================================
//  InitApp
// =====================================

BOOL
InitApp(HINSTANCE hInstance)
{
  ATOM aWndClass; //    
  WNDCLASS wc;    //   
                  //  

  memset(&wc, 0, sizeof(wc));
  wc.style         = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = (WNDPROC) WndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon   = LoadIcon(NULL, IDI_APPLICATION);
  wc.hCursor = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
  wc.lpszMenuName  = (LPSTR)NULL;
  wc.lpszClassName = (LPSTR)szClassName;

  aWndClass = RegisterClass(&wc);
  return (aWndClass != 0);
}

