#define STRICT
#include <windows.h>
#include <time.h>

//  ,  
//   
#define CLOCK_TIMER 1

//   
void CALLBACK _export TimerProc(HWND, UINT, UINT, DWORD);

//     ,
//      
int nBeepTimerID;

//  
extern TEXTMETRIC tm;
extern int cxChar, cyChar;

// =====================================
//  WndProc
// =====================================

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC        hdc;
  PAINTSTRUCT ps;

  switch (msg)
  {
    case WM_CREATE:
    {
      //  ,  
      //      
      SetTimer(hwnd, CLOCK_TIMER, 1000, NULL);

      //  ,  
      //      
      //   TimerProc
      nBeepTimerID = SetTimer(hwnd, 0,  1000,
          (TIMERPROC)TimerProc);

      hdc = GetDC(hwnd);

      //      
      SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

      //   
      //   ,  
      //  
      GetTextMetrics(hdc, &tm);

      //    
      //   
      cxChar = tm.tmMaxCharWidth;

      //     
      //   
      cyChar = tm.tmHeight + tm.tmExternalLeading;

      ReleaseDC(hwnd, hdc);
      return 0;
    }

    //    
    // ,   , 
    //    WM_NCHITTEST
    case WM_NCHITTEST:
    {
      long lRetVal;

      //   DefWindowProc  
      //   
      lRetVal = DefWindowProc(hwnd, msg, wParam, lParam);

      //       
      //   , 
      //    , 
      //  ,  
      //  DefWindowProc
      if(lRetVal == HTLEFT        ||
	 lRetVal == HTRIGHT       ||
	 lRetVal == HTTOP         ||
	 lRetVal == HTBOTTOM      ||
	 lRetVal == HTBOTTOMRIGHT ||
	 lRetVal == HTTOPRIGHT    ||
	 lRetVal == HTTOPLEFT     ||
	 lRetVal == HTBOTTOMLEFT)
      {
	return lRetVal;
      }

      //     
      // HTCAPTION,  
      //  .
      else
      {
	return HTCAPTION;
      }
    }

    //   
    //   
    case WM_TIMER:
    {
       InvalidateRect(hwnd, NULL, FALSE);
       return 0;
    }

    case WM_DESTROY:
    {
      //    
      //   
      KillTimer(hwnd, CLOCK_TIMER);
      KillTimer(hwnd, nBeepTimerID);

      PostQuitMessage(0);
      return 0;
    }

    case WM_PAINT:
    {
      BYTE   szBuf[80];
      int    nBufSize;
      time_t t;
      struct tm *ltime;
      RECT    rc;

      hdc = BeginPaint(hwnd, &ps);

      //      
      time(&t);
      ltime = localtime(&t);

      //  ,  
      //    
      nBufSize = wsprintf(szBuf, "%02d:%02d:%02d",
	ltime->tm_hour,
	ltime->tm_min,
	ltime->tm_sec);

      //      
      SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));

      //     
      GetClientRect(hwnd, &rc);

      //     
      DrawText(hdc, (LPSTR)szBuf, nBufSize, &rc,
	       DT_CENTER | DT_VCENTER | DT_NOCLIP | DT_SINGLELINE);

      EndPaint(hwnd, &ps);
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}

// =====================================
//  TimerProc
// =====================================
#pragma argsused
void CALLBACK _export
TimerProc(HWND hwnd, UINT msg, UINT idTimer, DWORD dwTime)
{
  //    
  MessageBeep(-1);
  return;
}

