// =====================================
//  WndProc
// =====================================

#define STRICT
#include <windows.h>
#include <stdio.h>
#include <string.h>

void Print(HDC, int, char *);

static int cxChar, cyChar;
static int cxCurrentPosition;
static int cyCurrentPosition;

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;              //   
  PAINTSTRUCT ps;       //   
  static TEXTMETRIC tm; //    
                        // 

  switch (msg)
  {
    case WM_CREATE:
    {
      //   ,
      //     
      hdc = GetDC(hwnd);

      //   
      //   ,  
      //  
      GetTextMetrics(hdc, &tm);

      //    
      //   
      cxChar = tm.tmMaxCharWidth;

      //     
      //   
      cyChar = tm.tmHeight + tm.tmExternalLeading;

      //   
      //  
      cxCurrentPosition = cxChar;
      cyCurrentPosition = cyChar;

      //  
      ReleaseDC(hwnd, hdc);
      return 0;
    }

    case WM_PAINT:
    {
      //   
      //  
      cxCurrentPosition = cxChar;
      cyCurrentPosition = cyChar;

      hdc = BeginPaint(hwnd, &ps);

      //   ,  
      //     
      //  WM_CREATE
      Print(hdc, tm.tmHeight,          "tmHeight");
      Print(hdc, tm.tmAscent,          "tmAscent");
      Print(hdc, tm.tmDescent,         "tmDescent");
      Print(hdc, tm.tmInternalLeading, "tmInternalLeading");
      Print(hdc, tm.tmExternalLeading, "tmExternalLeading");
      Print(hdc, tm.tmAveCharWidth,    "tmAveCharWidth");
      Print(hdc, tm.tmMaxCharWidth,    "tmMaxCharWidth");
      Print(hdc, tm.tmWeight,          "tmWeight");
      Print(hdc, tm.tmItalic,          "tmItalic");
      Print(hdc, tm.tmUnderlined,      "tmUnderlined");
      Print(hdc, tm.tmStruckOut,       "tmStruckOut");
      Print(hdc, tm.tmFirstChar,       "tmFirstChar");
      Print(hdc, tm.tmLastChar,        "tmLastChar");
      Print(hdc, tm.tmDefaultChar,     "tmDefaultChar");
      Print(hdc, tm.tmBreakChar,       "tmBreakChar");
      Print(hdc, tm.tmPitchAndFamily,  "tmPitchAndFamily");
      Print(hdc, tm.tmCharSet,         "tmCharSet");
      Print(hdc, tm.tmOverhang,        "tmOverhang");
      Print(hdc, tm.tmDigitizedAspectX,"tmDigitizedAspectX");
      Print(hdc, tm.tmDigitizedAspectY,"tmDigitizedAspectY");

      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_DESTROY:
    {
      PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}

// ==========================================
//     
//  
// ==========================================

void Print(HDC hdc, int tmValue, char *str)
{
  char buf[80];
  int i;

  //    
  //       
  //   
  sprintf(buf, "%s", str);
  i = strlen(str);

  TextOut(hdc,
    cxCurrentPosition,
    cyCurrentPosition,
    buf, i);

  //    
  //      
  //    
  sprintf(buf, "= %d", tmValue);
  i = strlen(buf);

  TextOut(hdc,
    cxCurrentPosition + 12 * cxChar,
    cyCurrentPosition,
    buf, i);

  //    
  //    
  cyCurrentPosition += cyChar;
}
