// ----------------------------------------
//   Windows
//    
// ----------------------------------------

#define STRICT
#include <windows.h>
#include <mem.h>

//  

BOOL InitApp(HINSTANCE);
LRESULT CALLBACK _export WndProc(HWND, UINT, WPARAM, LPARAM);

//   
char const szClassName[]   = "WindowAppClass";

//  
char const szWindowTitle[] = "Window Application";

// =====================================
//  WinMain
//    
// 
// =====================================
#pragma argsused

int PASCAL
WinMain(HINSTANCE hInstance,     //  
				 //  

	HINSTANCE hPrevInstance, //  
				 //  

	LPSTR     lpszCmdLine,   //    

	int       nCmdShow)      //   
	                         //  
{
  MSG  msg;   //     
  HWND hwnd;  //    

  // ,       
  if(!hPrevInstance)
  {
    //   ,   InitApp
    //   .
    //     ,
    //  
    if(!InitApp(hInstance))
      return FALSE;
  }

  //     ,
  //    ,  
  //     , 
  //    
  else
  {
    MessageBox(NULL,
         "     ",
	 "", MB_OK | MB_ICONSTOP);
    return FALSE;
  }

  //     
  //   
  hwnd = CreateWindow(
    szClassName,         //   
    szWindowTitle,       //  
    WS_OVERLAPPEDWINDOW, //  

    CW_USEDEFAULT,       //    
    CW_USEDEFAULT,       // ,    
    CW_USEDEFAULT,
    CW_USEDEFAULT,

    0,                   //   
    0,                   //  

    hInstance,           //  

    NULL);               //   
			 // 

  //     ,  
  if(!hwnd)
    return FALSE;

  //  .     ShowWindow, 
  // ,   UpdateWindows, 
  //  WM_PAINT   

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  //    

  while(GetMessage(&msg, 0, 0, 0))
  {
    DispatchMessage(&msg);
  }

  //   WParam, 
  //     PostQuitMessage
  //     
  //    .
  //    
  return msg.wParam;
}

// =====================================
//  InitApp
//    WinMain 
//  .
//    
// =====================================

BOOL
InitApp(HINSTANCE hInstance)
{
  ATOM aWndClass; //    
  WNDCLASS wc;    //   
                  //  

  //       
  memset(&wc, 0, sizeof(wc));

  //  
  wc.style = 0;

  //    , 
  // ,    ,
  //     
  wc.lpfnWndProc = (WNDPROC) WndProc;

  //    ,
  //     
  wc.cbClsExtra = 0;

  //    ,
  //    ,
  //     
  wc.cbWndExtra = 0;

  //  , 
  //   
  wc.hInstance = hInstance;

  //  , 
  //    
  wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);

  //  , 
  //    
  wc.hCursor = LoadCursor(NULL, IDC_ARROW);

  //   
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);

  //  
  wc.lpszMenuName = (LPSTR)NULL;

  // ,   
  //     
  //   
  wc.lpszClassName = (LPSTR)szClassName;

  //  

  aWndClass = RegisterClass(&wc);

  //    
  return (aWndClass != 0);
}

// =====================================
//  WndProc
//       .
//    Windows  
//  .     WndProc
//     .
//     
//  
// =====================================

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  //   . 
  //     msg 
  switch (msg)
  {
    //   ,    
    //        
    //   
    case WM_LBUTTONDOWN:
      {
        MessageBox(NULL,
         "   ",
	 "", MB_OK | MB_ICONINFORMATION);
	return 0;
      }

    //   ,    
    //        
    //   
    case WM_RBUTTONDOWN:
      {
	MessageBeep(-1); //  
	MessageBox(NULL,
	 "   ",
	 "", MB_OK | MB_ICONINFORMATION);
	return 0;
      }

    //   ,   
    //     
    // Windows 
    case WM_DESTROY:
    {
      //    ,
      //     
      // WM_QUIT.    
      //      WinMain

      PostQuitMessage(0);
      return 0;
    }
  }

  //  ,    
  //  ,   
  // DefWindowProc

  return DefWindowProc(hwnd, msg, wParam, lParam);
}