// =====================================
//  WndProc
// =====================================

#define STRICT
#include <windows.h>
#include <stdio.h>

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;             //   
  PAINTSTRUCT ps;      //   

  //  
  static WORD   xPos;
  static WORD   yPos;

  switch (msg)
  {
    case WM_PAINT:
    {
      char buf[80]; 

      hdc = BeginPaint(hwnd, &ps);

      sprintf(buf, "%4.4dx%4.4d   ", xPos, yPos);

      //   
      TextOut(hdc, 0, 0, buf, 12);

      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_MOVE:
    {
      // X-   
      //   
      xPos = LOWORD(lParam);

      // Y-   
      //   
      yPos = HIWORD(lParam);

      //     
      // 
      InvalidateRect(hwnd, NULL, TRUE);

      //    WM_PAINT
      UpdateWindow(hwnd);
      return 0;
    }

    case WM_SIZE:
    case WM_LBUTTONDOWN:
    {
      RECT rc;
      char buf[80];

      hdc = GetDC(hwnd);

      //   ,
      //  
      GetWindowRect(hwnd, &rc);

      sprintf(buf, "%4.4dx%4.4d %4.4dx%4.4d      ",
	rc.top,
	rc.left,
	rc.right,
	rc.bottom);

      //     
      TextOut(hdc, 0, 20, buf, 25);

      ReleaseDC(hwnd, hdc);
      return 0;
    }

    case WM_DESTROY:
    {
      PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}
