// =====================================
//  WndProc
//     
//  
// =====================================

#define STRICT
#include <windows.h>
#include <stdio.h>

LRESULT CALLBACK _export
WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;             //   
  PAINTSTRUCT ps;      //   

  static WPARAM fwSizeType;
  static WORD   nWidth;
  static WORD   nHeight;

  switch (msg)
  {
    case WM_PAINT:
    {
      char buf[80]; 

      hdc = BeginPaint(hwnd, &ps);

      sprintf(buf, "%4.4dx%4.4d (%1.1d)",
        nWidth, nHeight, fwSizeType);

      //   
      TextOut(hdc, 0, 0, buf, 13);

      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_SIZE:
    {
      //    
      fwSizeType = wParam;

      //    
      nWidth = LOWORD(lParam);

      //    
      nHeight = HIWORD(lParam);

      //     
      // 
      InvalidateRect(hwnd, NULL, TRUE);

      //    WM_PAINT
      UpdateWindow(hwnd);
      return 0;
    }

    case WM_LBUTTONDOWN:
    {
      RECT rcWndSize;
      char buf[80];

      hdc = GetDC(hwnd);

      //   
      //  
      GetClientRect(hwnd, &rcWndSize);

      sprintf(buf, "%4.4dx%4.4d",
	rcWndSize.right,
	rcWndSize.bottom);

      //     
      TextOut(hdc, 0, 20, buf, 9);

      ReleaseDC(hwnd, hdc);
      return 0;
    }

    case WM_DESTROY:
    {
      PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}
