// ----------------------------------------
//   
// ----------------------------------------

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <mem.h>

//  

BOOL Register(HINSTANCE);
LRESULT CALLBACK _export MainWndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK _export ChildWndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK _export PopUpWndProc(HWND, UINT, WPARAM, LPARAM);

//      
char const szMainClassName[]    = "WStyleAppClass";

//     
char const szChildClassName[]   = "WStyleAppChildClass";

//     
char const szPopUpClassName[]   = "WStyleAppPopUpClass";

//    
char const szMainWindowTitle[]  = "WStyle Application";

//   
char const szChildWindowTitle[] = " Child";

//   
char const szPopUpWindowTitle[] = " PopUp";

// =====================================
//  WinMain
// =====================================
#pragma argsused

int PASCAL
WinMain(HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR     lpszCmdLine,
	int       nCmdShow)
{
  MSG  msg;
  HWND MainHwnd;   //    
  HWND ChildHwnd;  //   
  HWND PopUpHwnd;  //   
  HWND OwnedHwnd;  //  ,  
                   //   

  //   
  if(!Register(hInstance))
      return FALSE;

  //    
  MainHwnd = CreateWindow(
    szMainClassName,     //   
    szMainWindowTitle,   //  
    WS_OVERLAPPEDWINDOW, //  
    CW_USEDEFAULT,       //    
    CW_USEDEFAULT,       // ,    
    CW_USEDEFAULT,
    CW_USEDEFAULT,
    0,                   //   
    0,                   //  
    hInstance,           //  
    NULL);               //   
			 // 

  //     ,  
  if(!MainHwnd)
    return FALSE;

  //   
  ShowWindow(MainHwnd, nCmdShow);

  //     WM_PAINT
  UpdateWindow(MainHwnd);

  //   , 
  //    
  OwnedHwnd = CreateWindow(
    szMainClassName,        //   
    " ", //  
    WS_OVERLAPPEDWINDOW,    //  
    20,                     //    
    200,                    // 
    300,
    100,
    MainHwnd,            //   
    0,                   //  
    hInstance,           //  
    NULL);               //   
			 // 

  //     ,  
  if(!OwnedHwnd)
    return FALSE;

  //   
  ShowWindow(OwnedHwnd, nCmdShow);

  //     WM_PAINT
  UpdateWindow(OwnedHwnd);

  //   
  ChildHwnd = CreateWindow(
    szChildClassName,     //   
    " ",      //  
    WS_CHILDWINDOW | WS_VISIBLE |
    WS_CAPTION,           //  
    300,                  //    
    20,                   // 
    200,
    100,
    MainHwnd,            //   
    0,                   //  
    hInstance,           //  
    NULL);               //   
			 // 

  //     ,  
  if(!ChildHwnd)
    return FALSE;

  //   
  PopUpHwnd = CreateWindow(
    szPopUpClassName,       //   
    " ",      //  
    WS_POPUPWINDOW | WS_CAPTION | WS_VISIBLE,  //  
    100,                    //    
    100,                    // 
    200,
    100,
    MainHwnd,            //   
    0,                   //  
    hInstance,           //  
    NULL);               //   
			 // 

  //     ,  
  if(!PopUpHwnd)
    return FALSE;

  //    
  while(GetMessage(&msg, 0, 0, 0))
  {
    DispatchMessage(&msg);
  }
  return msg.wParam;
}

// =====================================
//  Register
//    ,
//  
// =====================================

BOOL
Register(HINSTANCE hInstance)
{
  ATOM aWndClass; //    
  WNDCLASS wc;    //   
                  //  

  memset(&wc, 0, sizeof(wc));

// --------------------------------------------------
//     
//   
// --------------------------------------------------
  wc.style = 0;
  wc.lpfnWndProc   = (WNDPROC) MainWndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
  wc.lpszMenuName  = (LPSTR)NULL;
  wc.lpszClassName = (LPSTR)szMainClassName;

  aWndClass = RegisterClass(&wc);
  if(aWndClass == 0) return FALSE;

// --------------------------------------------------
//     
//  
// --------------------------------------------------

  wc.lpfnWndProc   = (WNDPROC) ChildWndProc;
  wc.hCursor       = LoadCursor(NULL, IDC_SIZE);
  wc.hbrBackground = GetStockBrush(GRAY_BRUSH);
  wc.lpszClassName = (LPSTR)szChildClassName;

  aWndClass = RegisterClass(&wc);
  if(aWndClass == 0) return FALSE;

// --------------------------------------------------
//    
//  
// --------------------------------------------------

  wc.lpfnWndProc   = (WNDPROC) PopUpWndProc;
  wc.hCursor       = LoadCursor(NULL, IDC_CROSS);
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
  wc.lpszClassName = (LPSTR)szPopUpClassName;

  aWndClass = RegisterClass(&wc);
  if(aWndClass == 0) return FALSE;

  return TRUE;
}

// =====================================
//  MainWndProc
//    
//   
//   
// =====================================

LRESULT CALLBACK _export
MainWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;             //   
  PAINTSTRUCT ps;      //   

  switch (msg)
  {
    case WM_PAINT:
    {
      hdc = BeginPaint(hwnd, &ps);
      TextOut(hdc, 10, 20, "WM_PAINT", 8);
      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_LBUTTONDOWN:
    {
      hdc = GetDC(hwnd);
      TextOut(hdc, 10, 40, "WM_LBUTTONDOWN", 14);
      ReleaseDC(hwnd, hdc);
      return 0;
    }

    case WM_DESTROY:
    {
      PostQuitMessage(0);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}

// =====================================
//  ChildWndProc
//   
// =====================================

LRESULT CALLBACK _export
ChildWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;             //   
  PAINTSTRUCT ps;      //   

  switch (msg)
  {
    case WM_PAINT:
    {
      hdc = BeginPaint(hwnd, &ps);
      TextOut(hdc, 10, 20, "WM_PAINT", 8);
      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_LBUTTONDOWN:
    {
      hdc = GetDC(hwnd);
      TextOut(hdc, 10, 40, "WM_LBUTTONDOWN", 14);
      ReleaseDC(hwnd, hdc);
      return 0;
    }

    case WM_RBUTTONDOWN:
      {
	MessageBeep(-1); //  
	return 0;
      }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}

// =====================================
//  PopUpWndProc
//   
// =====================================

LRESULT CALLBACK _export
PopUpWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  HDC hdc;             //   
  PAINTSTRUCT ps;      //   

  switch (msg)
  {
    case WM_PAINT:
    {
      hdc = BeginPaint(hwnd, &ps);
      TextOut(hdc, 10, 20, "WM_PAINT", 8);
      EndPaint(hwnd, &ps);
      return 0;
    }

    case WM_LBUTTONDOWN:
    {
      hdc = GetDC(hwnd);
      TextOut(hdc, 10, 40, "WM_LBUTTONDOWN", 14);
      ReleaseDC(hwnd, hdc);
      return 0;
    }
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}
