import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class BorderDemo extends Applet
  implements AdjustmentListener
{
  Scrollbar scrlVert;
  Scrollbar scrlHorz;
  picFrame pf;
  
  int nVert = 0;
  int nHorz = 0;
  
  int imHeight;
  int imWidth;
  
  // ============================================
  // init
  // ============================================
  public void init()
  {
    Image img;
    Dimension dm;
    
    MediaTracker tr = new MediaTracker(this);
    
    img = getImage(getCodeBase(), "image.gif");
    tr.addImage(img, 0);
    try
    {
      tr.waitForAll();
    }
    catch (InterruptedException e) {}
    
    imHeight = img.getHeight(this);
    imWidth = img.getWidth(this);
    
    dm = getSize();
    
    scrlVert = new Scrollbar(
      Scrollbar.VERTICAL, 0, 10, 
      0, imHeight - dm.height);
	
    scrlHorz = new Scrollbar(
      Scrollbar.HORIZONTAL, 0, 10, 
      0, imWidth - dm.width);
      
    pf = new picFrame(this, img);  
    
    setLayout(new BorderLayout());    
    
    add("Center", pf);    
    add("East", scrlVert);  
    add("South", scrlHorz);  
      
    scrlVert.addAdjustmentListener(this);
    scrlHorz.addAdjustmentListener(this);
  }
  
  // ============================================
  // adjustmentValueChanged
  // ============================================
  public void adjustmentValueChanged(
    AdjustmentEvent e)
  {
    Scrollbar scrl;
    int nValue;
    
    if(e.getSource() instanceof Scrollbar)
    {
      scrl = (Scrollbar)e.getSource();
      nValue = e.getValue();
      
      if(scrl.equals(scrlVert))
	nVert = nValue;
	
      else if(scrl.equals(scrlHorz))
	nHorz = nValue;
	
      pf.update(-nVert, -nHorz);	
    }
  }
  
  // ============================================
  // getAppletInfo
  // ============================================
  public String getAppletInfo()
  {
    return "Name: BorderDemo";
  }
}

// ============================================
// Class picFrame
// ============================================
class picFrame extends Canvas
{
  int imHeight;
  int imWidth;
  Image im;
  Dimension dimMinSize;
  
  int nVert = 0;
  int nHorz = 0;

  // ============================================
  // picFrame
  // ============================================
  public picFrame(Container parent, Image img)
  {
    Container cont;
    cont = parent;
    im = img;
    
    imHeight = im.getHeight(this);
    imWidth = im.getWidth(this);
    
    dimMinSize = new Dimension(
      imWidth / 4, imHeight / 4);
  }
  
  // ============================================
  // update
  // ============================================
  public void update(int Vert, int Horz)
  {
    nVert = Vert;
    nHorz = Horz;
    
    repaint();
  }

  // ===========================================
  // paint
  // ===========================================
  public void paint(Graphics g)
  {
    g.drawImage(im, nHorz, nVert, this);
  }
  
  // ===========================================
  // getPreferredSize
  // ===========================================
  public Dimension getPreferredSize()
  {
    return dimMinSize;
  }
  
  // ===========================================
  // getMinimumSize
  // ===========================================
  public Dimension getMinimumSize()
  {
    return dimMinSize;
  }
  
  // ===========================================
  // preferredSize
  // ===========================================
  public Dimension preferredSize()
  {
    return dimMinSize;
  }
  
  // ===========================================
  // minimumSize
  // ===========================================
  public Dimension minimumSize()
  {
    return dimMinSize;
  }
}