import java.io.*;
import java.util.*;

public class DirList 
{
  public static void main(String args[])
  {
    String s;
    int i;
    
    while(true)
    {    
      System.out.println(
	"Enter full path ('quit' to exit): ");
	
      s = new String(getKbdString());
      if(s.equals("quit"))
	break;
      
      File f = new File(s);
      
      if(!f.exists())
      {
        System.out.println("\nNot found: " + s);
	continue;
      }
      
      if(!f.isDirectory())
      {
        System.out.println("\nNot directory: " + s);
	continue;
      }
      
      String[] sDirList = f.list();
      
      for(i = 0; i < sDirList.length; i++)
      {
	File f1 = new File(s + File.separator + sDirList[i]);
	
	if(f1.isFile())
	  System.out.println(sDirList[i]);
	else  
	  System.out.println("-dir- " + sDirList[i]);
      }
    }  
  }

  // ============================================
  // getKbdString
  // ============================================
  static public String getKbdString()
  {
    byte bKbd[] = new byte[256];
    int iCnt = 0;
    String szStr = "";
    
    try
    {
      iCnt = System.in.read(bKbd);
    }
    catch(Exception ex)
    {
      System.out.println(ex.toString()); 
    }
      
    szStr = new String(bKbd, 0, iCnt);
    szStr = szStr.trim();
    return szStr;
  }
}

